# -*- coding: iso-8859-1 -*-

#####################################################################
# Daniel Calderon S.
# CC3501 - otoo 2011
#####################################################################

# Vector2D_test.py
# versin 20111_2d01
# ---------------
# Ejemplos de uso de la clase Vector2D.
# ---------------
# contenido:
## como crear y operar con vectores
## ejemplo 1: cinemtica (estatica)
## ejemplo 2: cinemtica (animacion)
## ejemplo 3: cercania de objetos (o colisin)
## ejemplo 4: movimiento circular

# Implementacin testeada con:
## Python 2.6

#####################################################################

from Vector2D import *
#import math as mt (se importa con Vector)

#####################################################################

####################################
### Construir un vector
####################################
# Construir un vector cartesiano (x=10,y=20)

a=Vector(10,20)

# Construir un vector polar (radio=10,angulo=pi/6)
# Obs: el ngulo debe estar en radianes

b=VectorPolar(10,mt.pi/6)

####################################
### Consultar componentes
####################################
# Se puede acceder a las componentes x, y, r (radio),a (ngulo)
# del siguiente modo

a.x()
a.y()
a.modulo()
a.angulo()

# Obs: se puede acceder a estos 4 valores independiente si el
# vector es polar o cartesiano. Internamente solo se almacenan
# los valores cartesianos (x e y).

# Se puede obtener una lista con la informacin del vector en
# cartesianas o polares.

a.cartesianas() #---> [x,y]
a.polares()     #---> [r,a]

####################################
### Operaciones con vectores y escalares
####################################
# Retornan un nuevo vector sin alterar los vectores dados como
# argumento. Sean a,b vectores, c un real y ang un angulo en radianes

a=Vector(10,20)
b=VectorPolar(10,mt.pi/6)
c=5
ang=mt.pi/8

sumar(a,b)      #---> suma vectorial : a+b
restar(a,b)     #---> diferencia vectorial : a-b
ponderar(c,b)   #---> pondera el vector b por el escalar c : c*b
normalizar(a)   #---> retorna un vector de norma 1 en la direccion de a
angulo(a,b)     #---> retorna el angulo entre a y b
rotar(b,ang)    #---> retorna un nuevo vector equivalente a b rotado en
                #     un angulo ang segun regla de la mano derecha
distancia(a,b)  #---> retorna la distancia entre los puntos indicados
                #     por los vectores a y b.
punto(a,b)      #---> retorna el producto punto entre
                #     a y b.

####################################
### Ejemplos de uso 
####################################

###
#1#
###

print ""
print "EJEMPLO 1 : cinematica (estatica)"
print ""

# para aceleracin constante, se tiene la siguiente expresion:
# r(t)=r0+v0*t+(a0/2)*(t**2)
# donde r,r0,v0,a0 son vectores

# se puede implementar dicha expresion del siguiente modo:

r0=Vector(0,0)
v0=VectorPolar(10,mt.pi/4)
a0=Vector(0,-10)

t=10
r=sumar(r0,sumar(ponderar(t,v0),ponderar(t**2,ponderar(.5,a0))))

print "posicin en t=10 : ",r.cartesianas()

###
#2#
###

print ""
print "EJEMPLO 2 : cinematica (animacion)"
print ""

# si se esta iterando (como en una animacion), lo que
# ocurre es que la aceleracion modifica la velocidad instantanea
# del objeto.
# Un objeto estar definido por su posicion y por su velocidad
# instantanea.

class Obj:
    def __init__(self,r,v):
        self.r = r   # posicion actual del objeto
        self.v = v   # velocidad instantanea del objeto

    def mover(self,dt,a):
        #acciones ocurridas en un intervalo de tiempo dt
        self.v = sumar(self.v,ponderar(dt,a))
        self.r = sumar(self.r,ponderar(dt,self.v))

# un ejemplo de uso de esta clase es:

r0=Vector(0,0)
v0=VectorPolar(10,mt.pi/4)
a0=Vector(0,-10)

punto=Obj(r0,v0)

# se calcula la posicin en intervalos de 1 segundo entre 0 y 10

ti=0 #intervalo inicial
for t in range(0,11):
    tf=t
    dt=tf-ti
    punto.mover(dt,a0)
    ti=tf

    print "posicin  en t=",t," : ",punto.r.cartesianas()
    print "velocidad en t=",t," : ",punto.v.cartesianas()

###
#3#
###

print ""
print "EJEMPLO 3 : Cercania de objetos (o colisin)"
print ""

# Detectar cercania de objetos. (aplicacion en colisiones)

obj1=Obj(Vector(0,0),Vector(0,0))
obj2=Obj(Vector(5,5),Vector(0,0))

if distancia(obj1.r,obj2.r)<=30:
    print "a menos de 30"
else:
    print "a mas de 30"

###
#4#
###

print ""
print "EJEMPLO 4 : movimiento circular"
print ""

r=VectorPolar(10,0)
ang=mt.pi/10

while r.angulo()<mt.pi:
    print "r = ",r.polares()," = ",r.cartesianas()
    r=rotar(r,ang)
    

